CSS_PSEUDO_CLASSES = [
  'active',
  'checked',
  'disabled',
  'empty',
  'enabled',
  'first-child',
  'first-of-type',
  'focus',
  'hover',
  'indeterminate',
  'last-child',
  'last-of-type',
  'link',
  'lang(|)',
  'not(|)',
  'nth-child(|)',
  'nth-last-child(|)',
  'nth-last-of-type(|)',
  'nth-of-type(|)',
  'only-child',
  'only-of-type',
  'root',
  'target',
  'visited']

CSS_PROP_VALUES = {'-moz-binding': [],
 '-moz-border-bottom-colors': [],
 '-moz-border-left-colors': [],
 '-moz-border-radius': [],
 '-moz-border-radius-bottomleft': [],
 '-moz-border-radius-bottomright': [],
 '-moz-border-radius-topleft': [],
 '-moz-border-radius-topright': [],
 '-moz-border-right-colors': [],
 '-moz-border-top-colors': [],
 '-moz-opacity': [],
 '-moz-outline': ['#ffffff',
                  'dashed',
                  'dotted',
                  'double',
                  'groove',
                  'hidden',
                  'inherit',
                  'inset',
                  'medium',
                  'none',
                  'outset',
                  'ridge',
                  'solid',
                  'thick',
                  'thin'],
 '-moz-outline-color': [],
 '-moz-outline-style': ['dashed',
                        'dotted',
                        'double',
                        'groove',
                        'hidden',
                        'inherit',
                        'inset',
                        'none',
                        'outset',
                        'ridge',
                        'solid'],
 '-moz-outline-width': ['*', 'inherit', 'medium', 'thick', 'thin'],
 '-moz-user-focus': ['auto', 'ignore', 'inherit', 'none', 'normal'],
 '-moz-user-input': ['auto', 'disabled', 'enabled', 'inherit', 'none'],
 '-moz-user-modify': ['inherit', 'read-only', 'read-write', 'write-only'],
 '-moz-user-select': ['all',
                      'element',
                      'elements',
                      'inherit',
                      'none',
                      'text',
                      'toggle',
                      'tri-state'],
 '-o-link': [],
 '-o-link-source': ['current', 'next', 'none'],
 'accelerator': ['false', 'inherit', 'true'],
 'alignment-adjust': ['<length>',
                      '<percentage>',
                      'after-edge',
                      'alphabetic',
                      'auto',
                      'baseline',
                      'before-edge ',
                      'central',
                      'hanging',
                      'ideographic',
                      'mathematical',
                      'middle',
                      'text-after-edge',
                      'text-before-edge'],
 'alignment-baseline': ['after-edge',
                        'alphabetic',
                        'baseline',
                        'before-edge',
                        'central',
                        'hanging',
                        'ideographic',
                        'mathematical',
                        'middle',
                        'text-after-edge',
                        'text-before-edge',
                        'use-script'],
 'animation': [],
 'animation-delay': [],
 'animation-direction': ['alternate', 'normal'],
 'animation-duration': [],
 'animation-iteration-count': [],
 'animation-name': [],
 'animation-play-state': [],
 'appearance': [],
 'azimuth': ['*',
             'behind',
             'center',
             'center-left',
             'center-right',
             'far-left',
             'far-right',
             'inherit',
             'left',
             'left-side',
             'leftwards',
             'right',
             'right-side',
             'rightwards'],
 'background': ['#ffffff',
                '*',
                'bottom',
                'center',
                'fixed',
                'inherit',
                'left',
                'no-repeat',
                'none',
                'repeat',
                'repeat-x',
                'repeat-y',
                'right',
                'scroll',
                'top',
                'url(image-url.gif)'],
 'background-attachment': ['fixed', 'inherit', 'scroll'],
 'background-clip': ['border-box', 'padding-box'],
 'background-color': [],
 'background-image': [],
 'background-origin': ['border-box', 'content-box', 'padding-box'],
 'background-position': ['*', 'bottom', 'center', 'left', 'right', 'top'],
 'background-position-x': ['*', 'center', 'left', 'right'],
 'background-position-y': ['*', 'bottom', 'center', 'top'],
 'background-repeat': ['no-repeat', 'repeat', 'repeat-x', 'repeat-y'],
 'background-size': ['contain', 'cover'],
 'baseline-shift': ['<length>', '<percentage>', 'baseline', 'sub', 'super'],
 'binding': ['<uri>', 'none'],
 'bookmark-label': [],
 'bookmark-level': [],
 'bookmark-target': [],
 'border': ['#ffffff',
            '*',
            'dashed',
            'dotted',
            'double',
            'groove',
            'hidden',
            'inherit',
            'inset',
            'medium',
            'none',
            'outset',
            'ridge',
            'solid',
            'thick',
            'thin'],
 'border-bottom': ['#ffffff',
                   '*',
                   'dashed',
                   'dotted',
                   'double',
                   'groove',
                   'hidden',
                   'inherit',
                   'inset',
                   'medium',
                   'none',
                   'outset',
                   'ridge',
                   'solid',
                   'thick',
                   'thin'],
 'border-bottom-color': [],
 'border-bottom-left-radius': [],
 'border-bottom-right-radius': [],
 'border-bottom-style': ['dashed',
                         'dotted',
                         'double',
                         'groove',
                         'hidden',
                         'inherit',
                         'inset',
                         'none',
                         'outset',
                         'ridge',
                         'solid'],
 'border-bottom-width': ['*', 'inherit', 'medium', 'thick', 'thin'],
 'border-collapse': ['collapse', 'inherit', 'separate'],
 'border-color': [],
 'border-left': ['#ffffff',
                 '*',
                 'dashed',
                 'dotted',
                 'double',
                 'groove',
                 'hidden',
                 'inherit',
                 'inset',
                 'medium',
                 'none',
                 'outset',
                 'ridge',
                 'solid',
                 'thick',
                 'thin'],
 'border-left-color': [],
 'border-left-style': ['dashed',
                       'dotted',
                       'double',
                       'groove',
                       'hidden',
                       'inherit',
                       'inset',
                       'none',
                       'outset',
                       'ridge',
                       'solid'],
 'border-left-width': ['*', 'inherit', 'medium', 'thick', 'thin'],
 'border-length': [],
 'border-radius': [],
 'border-right': ['#ffffff',
                  '*',
                  'dashed',
                  'dotted',
                  'double',
                  'groove',
                  'hidden',
                  'inherit',
                  'inset',
                  'medium',
                  'none',
                  'outset',
                  'ridge',
                  'solid',
                  'thick',
                  'thin'],
 'border-right-color': [],
 'border-right-style': ['dashed',
                        'dotted',
                        'double',
                        'groove',
                        'hidden',
                        'inherit',
                        'inset',
                        'none',
                        'outset',
                        'ridge',
                        'solid'],
 'border-right-width': ['*', 'inherit', 'medium', 'thick', 'thin'],
 'border-spacing': [],
 'border-style': ['dashed',
                  'dotted',
                  'double',
                  'groove',
                  'hidden',
                  'inherit',
                  'inset',
                  'none',
                  'outset',
                  'ridge',
                  'solid'],
 'border-top': ['#ffffff',
                '*',
                'dashed',
                'dotted',
                'double',
                'groove',
                'hidden',
                'inherit',
                'inset',
                'medium',
                'none',
                'outset',
                'ridge',
                'solid',
                'thick',
                'thin'],
 'border-top-color': [],
 'border-top-left-radius': [],
 'border-top-right-radius': [],
 'border-top-style': ['dashed',
                      'dotted',
                      'double',
                      'groove',
                      'hidden',
                      'inherit',
                      'inset',
                      'none',
                      'outset',
                      'ridge',
                      'solid'],
 'border-top-width': ['*', 'inherit', 'medium', 'thick', 'thin'],
 'border-width': ['*', 'inherit', 'medium', 'thick', 'thin'],
 'bottom': ['*', 'auto', 'inherit'],
 'box-align': ['baseline ', 'center', 'end', 'start', 'stretch'],
 'box-direction': ['normal', 'reverse'],
 'box-flex': [],
 'box-flex-group': [],
 'box-lines': ['multiple', 'single'],
 'box-ordinal-group': [],
 'box-orient': ['block-axis', 'horizontal', 'inline-axis', 'vertical'],
 'box-pack': ['center', 'end', 'justify', 'start'],
 'box-sizing': ['border-box', 'content-box'],
 'caption-side': ['bottom', 'inherit', 'left', 'right', 'top'],
 'clear': ['all', 'both', 'inherit', 'left', 'none', 'right'],
 'clip': ['*', 'auto', 'inherit'],
 'color': [],
 'color-profile': ['<name>', '<url>', 'auto', 'sRGB'],
 'column-count': ['<integer>', 'auto'],
 'column-fill': ['auto', 'balance'],
 'column-gap': ['<length>', 'normal'],
 'column-rule-color': [],
 'column-rule-style': [],
 'column-rule-width': [],
 'column-span': ['1', 'all'],
 'column-width': ['<length>', 'auto'],
 'columns': [],
 'columns-rule': [],
 'content': ['*',
             'close-quote',
             'inherit',
             'no-close-quote',
             'no-open-quote',
             'open-quote'],
 'counter-increment': ['*',
                       'decimal',
                       'decimal-leading-zero',
                       'inherit',
                       'lower-greek',
                       'lower-latin',
                       'lower-roman',
                       'none',
                       'upper-latin',
                       'upper-roman'],
 'counter-reset': ['*', 'inherit', 'none'],
 'crop': ['auto',
          'inset-rect(top, right, bottom, left)',
          'rect(top, right, bottom, left)'],
 'cue': [],
 'cue-after': [],
 'cue-before': [],
 'cursor': ['*',
            'auto',
            'crosshair',
            'default',
            'e-resize',
            'hand',
            'help',
            'inherit',
            'move',
            'n-resize',
            'ne-resize',
            'nw-resize',
            'pointer',
            'progress',
            's-resize',
            'se-resize',
            'sw-resize',
            'text',
            'w-resize',
            'wait'],
 'direction': ['inherit', 'ltr', 'rtl'],
 'display': ['block',
             'compact',
             'inherit',
             'inline',
             'inline-block',
             'inline-table',
             'list-item',
             'marker',
             'none',
             'run-in',
             'table',
             'table-caption',
             'table-cell',
             'table-column',
             'table-column-group',
             'table-footer-group',
             'table-header-group',
             'table-row',
             'table-row-group'],
 'dominant-baseline': ['alphabetic',
                       'auto',
                       'central',
                       'hanging',
                       'ideographic',
                       'mathematical',
                       'middle',
                       'no-change',
                       'reset-size',
                       'text-after-edge',
                       'text-before-edge',
                       'use-script'],
 'drop-initial-after-adjust': ['<length>',
                               '<percentage>',
                               'before-edge',
                               'central',
                               'hanging',
                               'mathematical',
                               'middle',
                               'text-before-edge'],
 'drop-initial-after-align': ['after-edge',
                              'alphabetic',
                              'baseline',
                              'before-edge',
                              'central',
                              'hanging',
                              'ideographic',
                              'mathematical',
                              'middle',
                              'text-after-edge',
                              'text-before-edge',
                              'use-script'],
 'drop-initial-before-adjust': ['<length>',
                                '<percentage>',
                                'before-edge',
                                'central',
                                'hanging',
                                'mathematical',
                                'middle',
                                'text-before-edge'],
 'drop-initial-before-align': ['after-edge',
                               'alphabetic',
                               'baseline',
                               'before-edge',
                               'caps-height',
                               'central',
                               'hanging',
                               'ideographic',
                               'mathematical',
                               'middle',
                               'text-after-edge',
                               'text-before-edge',
                               'use-script'],
 'drop-initial-size': ['<length>', '<line>', '<percentage>', 'auto'],
 'drop-initial-value': ['<integer>', 'initial'],
 'elevation': ['*', 'above', 'below', 'higher', 'inherit', 'level', 'lower'],
 'empty-cells': ['hide', 'inherit', 'show'],
 'filter': [],
 'fit': ['fill', 'hidden', 'meet', 'slice'],
 'fit-position': [],
 'float': ['inherit', 'left', 'none', 'right'],
 'font': ['"Agency FB"',
          '"Arial Black"',
          '"Arial Narrow"',
          '"Arial Rounded MT Bold"',
          '"Blackadder ITC"',
          '"Bodoni MT Black"',
          '"Bodoni MT Condensed"',
          '"Bodoni MT"',
          '"Book Antiqua"',
          '"Bookman Old Style"',
          '"Bookshelf Symbol 7"',
          '"Bradley Hand ITC"',
          '"Calisto MT"',
          '"Century Gothic"',
          '"Comic Sans MS"',
          '"Copperplate Gothic Bold"',
          '"Copperplate Gothic Light"',
          '"Courier New"',
          '"Courier New", Courier, monospace',
          '"Curlz MT"',
          '"Edwardian Script ITC"',
          '"Engravers MT"',
          '"Eras Bold ITC"',
          '"Eras Demi ITC"',
          '"Eras Light ITC"',
          '"Eras Medium ITC"',
          '"Estrangelo Edessa"',
          '"Felix Titling"',
          '"Franklin Gothic Book"',
          '"Franklin Gothic Demi Cond"',
          '"Franklin Gothic Demi"',
          '"Franklin Gothic Heavy"',
          '"Franklin Gothic Medium Cond"',
          '"Franklin Gothic Medium"',
          '"French Script MT"',
          '"Gill Sans MT Condensed"',
          '"Gill Sans MT Ext Condensed Bold"',
          '"Gill Sans MT"',
          '"Gill Sans Ultra Bold Condensed"',
          '"Gill Sans Ultra Bold"',
          '"Gloucester MT Extra Condensed"',
          '"Goudy Old Style"',
          '"Goudy Stout"',
          '"Imprint MT Shadow"',
          '"Lucida Console"',
          '"Lucida Grande"',
          '"Lucida Sans Typewriter"',
          '"Lucida Sans Unicode"',
          '"Lucida Sans"',
          '"MS Outlook"',
          '"MS Reference Sans Serif"',
          '"MS Reference Specialty"',
          '"MS Sans Serif"',
          '"MS Sans Serif", Geneva, sans-serif',
          '"MS Serif"',
          '"MS Serif", "New York", serif',
          '"MV Boli"',
          '"Maiandra GD"',
          '"Microsoft Sans Serif"',
          '"Monotype Corsiva"',
          '"New York"',
          '"OCR A Extended"',
          '"Palace Script MT"',
          '"Palatino Linotype"',
          '"Perpetua Titling MT"',
          '"Rage Italic"',
          '"Rockwell Condensed"',
          '"Rockwell Extra Bold"',
          '"SF Collegiate Solid"',
          '"SF Collegiate"',
          '"Script MT Bold"',
          '"Small Fonts"',
          '"Times New Roman"',
          '"Times New Roman", Times, serif',
          '"Trebuchet MS"',
          '"Tw Cen MT Condensed Extra Bold"',
          '"Tw Cen MT Condensed"',
          '"Tw Cen MT"',
          '"Wingdings 2"',
          '"Wingdings 3"',
          '"Zapf Dingbats"',
          '*',
          '100',
          '200',
          '300',
          '400',
          '500',
          '600',
          '700',
          '800',
          '900',
          'Arial',
          'Arial, Helvetica, sans-serif',
          'Castellar',
          'Charcoal',
          'Collegiate-Normal',
          'Courier',
          'Default',
          'Elephant',
          'Fixedsys',
          'Forte',
          'Futura',
          'Gadget',
          'Garamond',
          'Gautami',
          'Geneva',
          'Georgia',
          'Gigi',
          'Haettenschweiler',
          'Helvetica',
          'Impact',
          'Kartika',
          'Latha',
          'Mangal',
          'Marlett',
          'Modern',
          'Monaco',
          'Nina',
          'Palatino Linotype',
          'Papyrus',
          'Perpetua',
          'Pristina',
          'Raavi',
          'Rockwell',
          'Roman',
          'Script',
          'Shruti',
          'Sylfaen',
          'Symbol',
          'System',
          'Tahoma',
          'Terminal',
          'Times',
          'Tunga',
          'Verdana',
          'Verdana, Geneva, Arial, Helvetica, sans-serif',
          'Vrinda',
          'WST_Czec',
          'WST_Engl',
          'WST_Fren',
          'WST_Germ',
          'WST_Ital',
          'WST_Span',
          'WST_Swed',
          'Webdings',
          'Wingdings',
          'ZWAdobeF',
          'bold',
          'bolder',
          'condensed',
          'cursive',
          'expanded',
          'extra-condensed',
          'extra-expanded',
          'fantasy',
          'inherit',
          'italic',
          'large',
          'larger',
          'lighter',
          'medium',
          'monospace',
          'narrower',
          'none',
          'normal',
          'number',
          'oblique',
          'sans-serif',
          'semi-condensed',
          'semi-expanded',
          'serif',
          'small',
          'small-caps',
          'smaller',
          'ultra-condensed',
          'ultra-expanded',
          'wider',
          'x-large',
          'x-small',
          'xx-large',
          'xx-small'],
 'font-family': ['"Agency FB"',
                 '"Arial Black"',
                 '"Arial Narrow"',
                 '"Arial Rounded MT Bold"',
                 '"Blackadder ITC"',
                 '"Bodoni MT Black"',
                 '"Bodoni MT Condensed"',
                 '"Bodoni MT"',
                 '"Book Antiqua"',
                 '"Bookman Old Style"',
                 '"Bookshelf Symbol 7"',
                 '"Bradley Hand ITC"',
                 '"Calisto MT"',
                 '"Century Gothic"',
                 '"Comic Sans MS"',
                 '"Copperplate Gothic Bold"',
                 '"Copperplate Gothic Light"',
                 '"Courier New"',
                 '"Courier New", Courier, monospace',
                 '"Curlz MT"',
                 '"Edwardian Script ITC"',
                 '"Engravers MT"',
                 '"Eras Bold ITC"',
                 '"Eras Demi ITC"',
                 '"Eras Light ITC"',
                 '"Eras Medium ITC"',
                 '"Estrangelo Edessa"',
                 '"Felix Titling"',
                 '"Franklin Gothic Book"',
                 '"Franklin Gothic Demi Cond"',
                 '"Franklin Gothic Demi"',
                 '"Franklin Gothic Heavy"',
                 '"Franklin Gothic Medium Cond"',
                 '"Franklin Gothic Medium"',
                 '"French Script MT"',
                 '"Gill Sans MT Condensed"',
                 '"Gill Sans MT Ext Condensed Bold"',
                 '"Gill Sans MT"',
                 '"Gill Sans Ultra Bold Condensed"',
                 '"Gill Sans Ultra Bold"',
                 '"Gloucester MT Extra Condensed"',
                 '"Goudy Old Style"',
                 '"Goudy Stout"',
                 '"Imprint MT Shadow"',
                 '"Lucida Console"',
                 '"Lucida Grande"',
                 '"Lucida Sans Typewriter"',
                 '"Lucida Sans Unicode"',
                 '"Lucida Sans"',
                 '"MS Outlook"',
                 '"MS Reference Sans Serif"',
                 '"MS Reference Specialty"',
                 '"MS Sans Serif"',
                 '"MS Sans Serif", Geneva, sans-serif',
                 '"MS Serif"',
                 '"MS Serif", "New York", serif',
                 '"MV Boli"',
                 '"Maiandra GD"',
                 '"Microsoft Sans Serif"',
                 '"Monotype Corsiva"',
                 '"New York"',
                 '"OCR A Extended"',
                 '"Palace Script MT"',
                 '"Palatino Linotype"',
                 '"Perpetua Titling MT"',
                 '"Rage Italic"',
                 '"Rockwell Condensed"',
                 '"Rockwell Extra Bold"',
                 '"SF Collegiate Solid"',
                 '"SF Collegiate"',
                 '"Script MT Bold"',
                 '"Small Fonts"',
                 '"Times New Roman"',
                 '"Times New Roman", Times, serif',
                 '"Trebuchet MS"',
                 '"Tw Cen MT Condensed Extra Bold"',
                 '"Tw Cen MT Condensed"',
                 '"Tw Cen MT"',
                 '"Wingdings 2"',
                 '"Wingdings 3"',
                 '"Zapf Dingbats"',
                 '*',
                 'Arial',
                 'Arial, Helvetica, sans-serif',
                 'Castellar',
                 'Charcoal',
                 'Collegiate-Normal',
                 'Courier',
                 'Default',
                 'Elephant',
                 'Fixedsys',
                 'Forte',
                 'Futura',
                 'Gadget',
                 'Garamond',
                 'Gautami',
                 'Geneva',
                 'Georgia',
                 'Gigi',
                 'Haettenschweiler',
                 'Helvetica',
                 'Impact',
                 'Kartika',
                 'Latha',
                 'Mangal',
                 'Marlett',
                 'Modern',
                 'Monaco',
                 'Nina',
                 'Palatino Linotype',
                 'Papyrus',
                 'Perpetua',
                 'Pristina',
                 'Raavi',
                 'Rockwell',
                 'Roman',
                 'Script',
                 'Shruti',
                 'Sylfaen',
                 'Symbol',
                 'System',
                 'Tahoma',
                 'Terminal',
                 'Times',
                 'Tunga',
                 'Verdana',
                 'Verdana, Geneva, Arial, Helvetica, sans-serif',
                 'Vrinda',
                 'WST_Czec',
                 'WST_Engl',
                 'WST_Fren',
                 'WST_Germ',
                 'WST_Ital',
                 'WST_Span',
                 'WST_Swed',
                 'Webdings',
                 'Wingdings',
                 'ZWAdobeF',
                 'cursive',
                 'fantasy',
                 'inherit',
                 'monospace',
                 'sans-serif',
                 'serif'],
 'font-size': ['*',
               'inherit',
               'large',
               'larger',
               'medium',
               'small',
               'smaller',
               'x-large',
               'x-small',
               'xx-large',
               'xx-small'],
 'font-size-adjust': [],
 'font-stretch': ['condensed',
                  'expanded',
                  'extra-condensed',
                  'extra-expanded',
                  'narrower',
                  'normal',
                  'semi-condensed',
                  'semi-expanded',
                  'ultra-condensed',
                  'ultra-expanded',
                  'wider'],
 'font-style': ['inherit', 'italic', 'normal', 'oblique'],
 'font-variant': ['inherit', 'normal', 'small-caps'],
 'font-weight': ['100',
                 '200',
                 '300',
                 '400',
                 '500',
                 '600',
                 '700',
                 '800',
                 '900',
                 'bold',
                 'bolder',
                 'inherit',
                 'lighter',
                 'normal'],
 'hanging-punctuation': ['end', 'end-edge', 'start'],
 'height': ['*', 'auto', 'inherit'],
 'hyphenate-after': [],
 'hyphenate-before': [],
 'hyphenate-lines': [],
 'hyphenate-resource': [],
 'hyphens': ['auto', 'manual', 'none'],
 'icon': ['<uri>', 'auto'],
 'image-orientation': ['<angle>', 'auto'],
 'image-resolution': ['<dpi>', 'auto', 'normal'],
 'ime-mode': ['active', 'auto', 'disabled', 'inactive'],
 'inline-box-align': ['<integer>', 'initial', 'last'],
 'layout-flow': ['horizontal', 'vertical-ideographic'],
 'layout-grid': ['horizontal', 'vertical-ideographic'],
 'layout-grid-char': ['*', 'auto', 'none'],
 'layout-grid-line': ['*', 'auto', 'none'],
 'layout-grid-mode': ['both', 'char', 'line', 'none'],
 'layout-grid-type': ['fixed', 'loose', 'strict'],
 'left': ['*', 'auto', 'inherit'],
 'letter-spacing': ['*', 'inherit', 'normal'],
 'line-break': ['normal', 'strict'],
 'line-height': ['*', 'inherit', 'normal'],
 'line-stacking': [],
 'line-stacking-ruby': ['exclude-ruby', 'include-ruby'],
 'line-stacking-shift': ['consider-shifts', 'disregard-shifts'],
 'line-stacking-strategy': ['block-line-height',
                            'grid-height',
                            'inline-line-height',
                            'max-height'],
 'list-style': ['armenian',
                'circle',
                'cjk-ideographic',
                'decimal',
                'decimal-leading-zero',
                'disc',
                'georgian',
                'hebrew',
                'hiragana',
                'hiragana-iroha',
                'inherit',
                'inside',
                'katakana',
                'katakana-iroha',
                'lower-alpha',
                'lower-greek',
                'lower-latin',
                'lower-roman',
                'none',
                'outside',
                'square',
                'upper-alpha',
                'upper-latin',
                'upper-roman',
                'url(image-url.gif)'],
 'list-style-image': [],
 'list-style-position': ['inherit', 'inside', 'outside'],
 'list-style-type': ['armenian',
                     'circle',
                     'cjk-ideographic',
                     'decimal',
                     'decimal-leading-zero',
                     'disc',
                     'georgian',
                     'hebrew',
                     'hiragana',
                     'hiragana-iroha',
                     'inherit',
                     'katakana',
                     'katakana-iroha',
                     'lower-alpha',
                     'lower-greek',
                     'lower-latin',
                     'lower-roman',
                     'none',
                     'square',
                     'upper-alpha',
                     'upper-latin',
                     'upper-roman'],
 'margin': [],
 'margin-bottom': [],
 'margin-left': [],
 'margin-right': [],
 'margin-top': [],
 'mark': [],
 'mark-after': [],
 'mark-before': [],
 'marker-offset': [],
 'marks': ['crop', 'cross', 'inherit', 'none'],
 'marquee-direction': ['forward', 'reverse'],
 'marquee-play-count': [],
 'marquee-speed': ['fast', 'normal', 'slow'],
 'marquee-style': ['alternate', 'scroll', 'slide'],
 'max-height': [],
 'max-width': [],
 'min-height': [],
 'min-width': [],
 'move-to': ['<identifier>', 'here', 'normal'],
 'nav-down': ['<id>', '<target-name>', 'auto'],
 'nav-index': ['<number>', 'auto'],
 'nav-left': ['<id>', '<target-name>', 'auto'],
 'nav-up': ['<id>', '<target-name>', 'auto'],
 'opacity': [],
 'orphans': [],
 'outline': ['#ffffff',
             'dashed',
             'dotted',
             'double',
             'groove',
             'hidden',
             'inherit',
             'inset',
             'medium',
             'none',
             'outset',
             'ridge',
             'solid',
             'thick',
             'thin'],
 'outline-color': [],
 'outline-offset': [],
 'outline-style': ['dashed',
                   'dotted',
                   'double',
                   'groove',
                   'hidden',
                   'inherit',
                   'inset',
                   'none',
                   'outset',
                   'ridge',
                   'solid'],
 'outline-width': ['*', 'inherit', 'medium', 'thick', 'thin'],
 'overflow': ['auto', 'hidden', 'inherit', 'scroll', 'visible'],
 'overflow-style': ['auto', 'marquee-block', 'marquee-line'],
 'overflow-x': ['auto', 'hidden', 'inherit', 'scroll', 'visible'],
 'overflow-y': ['auto', 'hidden', 'inherit', 'scroll', 'visible'],
 'padding': [],
 'padding-bottom': [],
 'padding-left': [],
 'padding-right': [],
 'padding-top': [],
 'page': [],
 'page-break-after': ['always', 'auto', 'avoid', 'inherit', 'left', 'right'],
 'page-break-before': ['always', 'auto', 'avoid', 'inherit', 'left', 'right'],
 'page-break-inside': ['always', 'auto', 'avoid', 'inherit'],
 'page-policy': ['first', 'last', 'start'],
 'pause': [],
 'pause-after': [],
 'pause-before': [],
 'phonemes': [],
 'pitch': ['high', 'inherit', 'low', 'medium', 'x-high', 'x-low'],
 'pitch-range': [],
 'play-during': ['auto', 'inherit', 'mix', 'none', 'repeat'],
 'position': ['absolute', 'fixed', 'inherit', 'relative', 'static'],
 'presentation-level': ['<integer>', 'increment', 'same'],
 'punctuation-trim': ['adjacent', 'end', 'none', 'start'],
 'quotes': [],
 'rendering-intent': [],
 'resize': ['both', 'horizontal', 'none', 'vertical'],
 'rest': [],
 'rest-after': ['<length>',
                'medium',
                'none',
                'strong',
                'weak',
                'x-strong',
                'x-weak'],
 'rest-before': ['<length>',
                 'medium',
                 'none',
                 'strong',
                 'weak',
                 'x-strong',
                 'x-weak'],
 'richness': [],
 'right': ['*', 'auto', 'inherit'],
 'rotation': [],
 'rotation-point': [],
 'ruby-align': ['auto',
                'center',
                'distribute-letter',
                'distribute-space',
                'inherit',
                'left',
                'line-edge',
                'right'],
 'ruby-overhang': ['auto', 'none', 'whitespace'],
 'ruby-position': ['above', 'inline'],
 'ruby-span': ['attr(x)', 'none'],
 'scrollbar-3dlight-color': [],
 'scrollbar-arrow-color': [],
 'scrollbar-base-color': [],
 'scrollbar-darkshadow-color': [],
 'scrollbar-face-color': [],
 'scrollbar-highlight-color': [],
 'scrollbar-shadow-color': [],
 'scrollbar-track-color': [],
 'size': ['*', 'auto', 'landscape', 'portrait'],
 'speak': ['inherit', 'none', 'normal', 'spell-out'],
 'speak-header': ['always', 'inherit', 'once'],
 'speak-numeral': ['continuous', 'digits', 'inherit'],
 'speak-punctuation': ['code', 'inherit', 'none'],
 'speech-rate': ['*',
                 'fast',
                 'faster',
                 'inherit',
                 'medium',
                 'slow',
                 'slower',
                 'x-fast',
                 'x-slow'],
 'stress': [],
 'string-set': [],
 'table-layout': ['auto', 'fixed', 'inherit'],
 'target': [],
 'target-name': ['<string>', 'current', 'modal', 'new', 'parent ', 'root'],
 'target-new': ['none', 'tab', 'window'],
 'target-position': ['above', 'back', 'behind', 'front'],
 'text-align': ['center', 'inherit', 'justify', 'left', 'right'],
 'text-align-last': ['auto', 'center', 'inherit', 'justify', 'left', 'right'],
 'text-decoration': ['blink',
                     'inherit',
                     'line-through',
                     'none',
                     'overline',
                     'underline'],
 'text-emphasis': ['accent',
                   'after',
                   'before',
                   'circle',
                   'disc',
                   'dot',
                   'none'],
 'text-height': ['auto', 'font-size', 'max-size', 'text-size'],
 'text-indent': [],
 'text-justify': ['auto',
                  'distribute',
                  'distribute-all-lines',
                  'distribute-center-last',
                  'inter-cluster',
                  'inter-ideograph',
                  'inter-word',
                  'kashida',
                  'newspaper'],
 'text-outline': [],
 'text-overflow': ['clip', 'ellipsis'],
 'text-replace': [],
 'text-shadow': [],
 'text-transform': ['capitalize', 'inherit', 'lowercase', 'none', 'uppercase'],
 'text-underline-position': ['above', 'auto', 'auto-pos', 'below'],
 'text-wrap': ['capitalize', 'lowercase', 'none', 'uppercase'],
 'top': ['*', 'auto', 'inherit'],
 'transition': [],
 'transition-delay': [],
 'transition-duration': [],
 'transition-property': [],
 'unicode-bidi': ['bidi-override', 'embed', 'inherit', 'normal'],
 'vertical-align': ['*',
                    'baseline',
                    'bottom',
                    'inherit',
                    'middle',
                    'sub',
                    'super',
                    'text-bottom',
                    'text-top',
                    'top'],
 'visibility': ['collapse', 'hidden', 'inherit', 'visible'],
 'voice-balance': ['<length>',
                   'center',
                   'left',
                   'leftwards',
                   'right',
                   'rightwards'],
 'voice-duration': ['<time>'],
 'voice-family': ['*', 'child', 'female', 'male'],
 'voice-pitch': ['<number>',
                 '<percentage>',
                 'high',
                 'low',
                 'medium',
                 'x-high',
                 'x-low'],
 'voice-pitch-range': ['<number>',
                       '<percentage>',
                       'high',
                       'low',
                       'medium',
                       'x-high',
                       'x-low'],
 'voice-rate': ['<percentage>', 'fast', 'medium', 'slow', 'x-fast', 'x-slow'],
 'voice-stress': ['moderate', 'none', 'reduced', 'strong'],
 'voice-volume': ['<number>',
                  '<percentage>',
                  'loud',
                  'medium',
                  'soft',
                  'x-loud',
                  'x-soft'],
 'volume': ['*', 'loud', 'medium', 'silent', 'soft', 'x-loud', 'x-soft'],
 'white-space': ['normal', 'nowrap', 'pre', 'pre-line', 'pre-wrap'],
 'white-space-collapse': ['collapse',
                          'discard',
                          'preserve',
                          'preserve-breaks'],
 'widows': [],
 'width': ['*', 'auto', 'inherit'],
 'word-break': ['break-all', 'keep-all', 'normal'],
 'word-spacing': [],
 'word-wrap': ['break-word', 'normal'],
 'writing-mode': ['lr-tb', 'tb-rl'],
 'z-index': [],
 'zoom': ['*', 'normal']}

HTML_ELEMENTS_ATTRIBUTES = {'!DOCTYPE': [],
 'a': ['accesskey',
       'charset',
       'class',
       'contenteditable',
       'coords',
       'datafld',
       'datasrc',
       'dir',
       'disabled',
       'hidefocus',
       'href',
       'hreflang',
       'id',
       'lang',
       'language',
       'methods',
       'name',
       'rel',
       'rev',
       'shape',
       'style',
       'tabindex',
       'target',
       'title',
       'type',
       'unselectable',
       'urn'],
 'abbr': ['class', 'dir', 'id', 'lang', 'style', 'title'],
 'acronym': ['class', 'dir', 'id', 'lang', 'style', 'title'],
 'address': ['accesskey',
             'class',
             'contenteditable',
             'dir',
             'disabled',
             'hidefocus',
             'id',
             'lang',
             'language',
             'style',
             'tabindex',
             'title',
             'unselectable'],
 'applet': ['accesskey',
            'align',
            'alt',
            'archive',
            'class',
            'code',
            'codebase',
            'datafld',
            'datasrc',
            'height',
            'hidefocus',
            'hspace',
            'id',
            'mayscript',
            'name',
            'object',
            'src',
            'style',
            'tabindex',
            'title',
            'unselectable',
            'vspace',
            'width'],
 'area': ['accesskey',
          'alt',
          'class',
          'coords',
          'dir',
          'hidefocus',
          'href',
          'id',
          'lang',
          'nohref',
          'shape',
          'style',
          'tabindex',
          'target',
          'title',
          'unselectable'],
 'article': ['accesskey',
             'class',
             'contenteditable',
             'contextmenu',
             'dir',
             'draggable',
             'hidden',
             'id',
             'lang',
             'spellcheck',
             'style',
             'tabindex',
             'title'],
 'aside': ['accesskey',
           'class',
           'contenteditable',
           'contextmenu',
           'dir',
           'draggable',
           'hidden',
           'id',
           'lang',
           'spellcheck',
           'style',
           'tabindex',
           'title'],
 'audio': ['accesskey',
           'autoplay',
           'class',
           'contenteditable',
           'contextmenu',
           'controls',
           'dir',
           'draggable',
           'hidden',
           'id',
           'lang',
           'loop',
           'preload',
           'spellcheck',
           'src',
           'style',
           'tabindex',
           'title'],
 'b': ['accesskey',
       'class',
       'contenteditable',
       'dir',
       'hidefocus',
       'id',
       'lang',
       'language',
       'style',
       'tabindex',
       'title',
       'unselectable'],
 'base': ['href', 'id', 'target'],
 'basefont': ['color', 'face', 'id', 'size'],
 'bdo': ['accesskey',
         'class',
         'contenteditable',
         'dir',
         'hidefocus',
         'id',
         'lang',
         'language',
         'style',
         'tabindex',
         'title',
         'unselectable'],
 'bgsound': ['balance', 'id', 'loop', 'src', 'volume'],
 'big': ['accesskey',
         'class',
         'contenteditable',
         'dir',
         'disabled',
         'hidefocus',
         'id',
         'lang',
         'language',
         'style',
         'tabindex',
         'title',
         'unselectable'],
 'blink': ['class', 'id', 'lang', 'style'],
 'blockquote': ['accesskey',
                'cite',
                'class',
                'contenteditable',
                'dir',
                'disabled',
                'hidefocus',
                'id',
                'lang',
                'language',
                'style',
                'tabindex',
                'title',
                'unselectable'],
 'body': ['accesskey',
          'alink',
          'background',
          'bgcolor',
          'bgproperties',
          'bottommargin',
          'class',
          'contenteditable',
          'dir',
          'disabled',
          'hidefocus',
          'id',
          'lang',
          'language',
          'leftmargin',
          'link',
          'marginheight',
          'marginwidth',
          'nowrap',
          'rightmargin',
          'scroll',
          'style',
          'tabindex',
          'text',
          'title',
          'unselectable',
          'vlink'],
 'br': ['class', 'clear', 'id', 'style', 'title'],
 'button': ['accesskey',
            'class',
            'contenteditable',
            'datafld',
            'dataformatas',
            'datasrc',
            'hidefocus',
            'id',
            'lang',
            'language',
            'name',
            'style',
            'tabindex',
            'title',
            'type',
            'value'],
 'canvas': ['accesskey',
            'class',
            'contenteditable',
            'contextmenu',
            'dir',
            'draggable',
            'height',
            'hidden',
            'id',
            'lang',
            'spellcheck',
            'style',
            'tabindex',
            'title',
            'width'],
 'caption': ['accesskey',
             'align',
             'class',
             'contenteditable',
             'dir',
             'hidefocus',
             'id',
             'lang',
             'language',
             'style',
             'tabindex',
             'title',
             'unselectable',
             'valign'],
 'center': ['accesskey',
            'class',
            'contenteditable',
            'dir',
            'disabled',
            'hidefocus',
            'id',
            'lang',
            'language',
            'style',
            'tabindex',
            'title',
            'unselectable'],
 'cite': ['accesskey',
          'class',
          'contenteditable',
          'dir',
          'disabled',
          'hidefocus',
          'id',
          'lang',
          'language',
          'style',
          'tabindex',
          'title',
          'unselectable'],
 'code': ['class',
          'contenteditable',
          'dir',
          'disabled',
          'id',
          'lang',
          'language',
          'style',
          'title',
          'unselectable'],
 'col': ['align',
         'bgcolor',
         'char',
         'charoff',
         'class',
         'dir',
         'id',
         'lang',
         'span',
         'style',
         'title',
         'valign',
         'width'],
 'colgroup': ['align',
              'bgcolor',
              'char',
              'charoff',
              'class',
              'dir',
              'id',
              'lang',
              'span',
              'style',
              'title',
              'valign',
              'width'],
 'command': ['accesskey',
             'checked',
             'class',
             'contenteditable',
             'contextmenu',
             'dir',
             'disabled',
             'draggable',
             'height',
             'hidden',
             'icon',
             'id',
             'label',
             'lang',
             'radiogroup',
             'spellcheck',
             'style',
             'tabindex',
             'title',
             'type',
             'width'],
 'comment': ['data', 'id', 'lang', 'title'],
 'datalist': ['accesskey',
              'class',
              'contenteditable',
              'contextmenu',
              'dir',
              'draggable',
              'hidden',
              'id',
              'lang',
              'spellcheck',
              'style',
              'tabindex',
              'title'],
 'dd': ['accesskey',
        'class',
        'contenteditable',
        'dir',
        'disabled',
        'hidefocus',
        'id',
        'lang',
        'language',
        'nowrap',
        'style',
        'tabindex',
        'title',
        'unselectable'],
 'del': ['accesskey',
         'cite',
         'class',
         'contenteditable',
         'datetime',
         'dir',
         'disabled',
         'id',
         'lang',
         'language',
         'style',
         'tabindex',
         'title',
         'unselectable'],
 'details': ['accesskey',
             'class',
             'contenteditable',
             'contextmenu',
             'dir',
             'draggable',
             'hidden',
             'id',
             'lang',
             'open',
             'spellcheck',
             'style',
             'tabindex',
             'title'],
 'dfn': ['accesskey',
         'class',
         'contenteditable',
         'dir',
         'disabled',
         'hidefocus',
         'id',
         'lang',
         'language',
         'style',
         'tabindex',
         'title',
         'unselectable'],
 'dir': ['accesskey',
         'contenteditable',
         'dir',
         'disabled',
         'hidefocus',
         'language',
         'tabindex',
         'unselectable'],
 'div': ['accesskey',
         'align',
         'class',
         'contenteditable',
         'dir',
         'disabled',
         'hidefocus',
         'id',
         'lang',
         'language',
         'nowrap',
         'style',
         'tabindex',
         'title',
         'unselectable'],
 'dl': ['accesskey',
        'class',
        'compact',
        'contenteditable',
        'dir',
        'disabled',
        'hidefocus',
        'id',
        'lang',
        'language',
        'style',
        'tabindex',
        'title',
        'unselectable'],
 'dt': ['accesskey',
        'class',
        'compact',
        'contenteditable',
        'dir',
        'disabled',
        'hidefocus',
        'id',
        'lang',
        'language',
        'nowrap',
        'style',
        'tabindex',
        'title',
        'unselectable'],
 'em': ['accesskey',
        'class',
        'contenteditable',
        'dir',
        'disabled',
        'hidefocus',
        'id',
        'lang',
        'language',
        'style',
        'tabindex',
        'title',
        'unselectable'],
 'embed': ['accesskey',
           'align',
           'alt',
           'border',
           'class',
           'code',
           'codebase',
           'height',
           'hidden',
           'hspace',
           'id',
           'language',
           'name',
           'palette',
           'pluginspage',
           'src',
           'style',
           'title',
           'type',
           'units',
           'unselectable',
           'vspace',
           'width'],
 'fieldset': ['accesskey',
              'align',
              'class',
              'contenteditable',
              'datafld',
              'dir',
              'disabled',
              'hidefocus',
              'id',
              'lang',
              'language',
              'style',
              'tabindex',
              'title',
              'unselectable'],
 'figcaption': ['accesskey',
                'class',
                'contenteditable',
                'contextmenu',
                'dir',
                'draggable',
                'hidden',
                'id',
                'lang',
                'spellcheck',
                'style',
                'tabindex',
                'title'],
 'figure': ['accesskey',
            'class',
            'contenteditable',
            'contextmenu',
            'dir',
            'draggable',
            'hidden',
            'id',
            'lang',
            'spellcheck',
            'style',
            'tabindex',
            'title'],
 'font': ['accesskey',
          'class',
          'color',
          'contenteditable',
          'dir',
          'disabled',
          'face',
          'hidefocus',
          'id',
          'lang',
          'language',
          'point-size',
          'size',
          'style',
          'tabindex',
          'title',
          'unselectable',
          'weight'],
 'footer': ['accesskey',
            'class',
            'contenteditable',
            'contextmenu',
            'dir',
            'draggable',
            'hidden',
            'id',
            'lang',
            'spellcheck',
            'style',
            'tabindex',
            'title'],
 'form': ['accept-charset',
          'action',
          'autocomplete',
          'class',
          'contenteditable',
          'dir',
          'disabled',
          'enctype',
          'hidefocus',
          'id',
          'lang',
          'language',
          'method',
          'name',
          'style',
          'tabindex',
          'target',
          'title',
          'unselectable'],
 'frame': ['allowtransparency',
           'application',
           'bordercolor',
           'class',
           'datafld',
           'datasrc',
           'frameborder',
           'height',
           'hidefocus',
           'id',
           'lang',
           'language',
           'longdesc',
           'marginheight',
           'marginwidth',
           'name',
           'noresize',
           'scrolling',
           'security',
           'style',
           'tabindex',
           'title',
           'unselectable',
           'width'],
 'frameset': ['border',
              'bordercolor',
              'class',
              'cols',
              'frameborder',
              'framespacing',
              'hidefocus',
              'id',
              'lang',
              'language',
              'longdesc',
              'rows',
              'style',
              'tabindex',
              'title',
              'unselectable'],
 'h1': ['accesskey',
        'align',
        'class',
        'contenteditable',
        'dir',
        'disabled',
        'hidefocus',
        'id',
        'lang',
        'language',
        'style',
        'tabindex',
        'title',
        'unselectable'],
 'h2': ['accesskey',
        'align',
        'class',
        'contenteditable',
        'dir',
        'disabled',
        'hidefocus',
        'id',
        'lang',
        'language',
        'style',
        'tabindex',
        'title',
        'unselectable'],
 'h3': ['accesskey',
        'align',
        'class',
        'contenteditable',
        'dir',
        'disabled',
        'hidefocus',
        'id',
        'lang',
        'language',
        'style',
        'tabindex',
        'title',
        'unselectable'],
 'h4': ['accesskey',
        'align',
        'class',
        'contenteditable',
        'dir',
        'disabled',
        'hidefocus',
        'id',
        'lang',
        'language',
        'style',
        'tabindex',
        'title',
        'unselectable'],
 'h5': ['accesskey',
        'align',
        'class',
        'contenteditable',
        'dir',
        'disabled',
        'hidefocus',
        'id',
        'lang',
        'language',
        'style',
        'tabindex',
        'title',
        'unselectable'],
 'h6': ['accesskey',
        'align',
        'class',
        'contenteditable',
        'dir',
        'disabled',
        'hidefocus',
        'id',
        'lang',
        'language',
        'style',
        'tabindex',
        'title',
        'unselectable'],
 'head': ['class', 'dir', 'id', 'lang', 'profile'],
 'header': ['accesskey',
            'class',
            'contenteditable',
            'contextmenu',
            'dir',
            'draggable',
            'hidden',
            'id',
            'lang',
            'spellcheck',
            'style',
            'tabindex',
            'title'],
 'hgroup': ['accesskey',
            'class',
            'contenteditable',
            'contextmenu',
            'dir',
            'draggable',
            'hidden',
            'id',
            'lang',
            'spellcheck',
            'style',
            'tabindex',
            'title'],
 'hr': ['accesskey',
        'align',
        'class',
        'dir',
        'hidefocus',
        'id',
        'lang',
        'language',
        'noshade',
        'size',
        'style',
        'tabindex',
        'title',
        'unselectable'],
 'html': ['class', 'dir', 'id', 'lang', 'scroll', 'xmlns'],
 'i': ['accesskey',
       'class',
       'dir',
       'disabled',
       'hidefocus',
       'id',
       'lang',
       'language',
       'style',
       'tabindex',
       'title',
       'unselectable'],
 'iframe': ['align',
            'allowtransparency',
            'application',
            'bordercolor',
            'class',
            'datafld',
            'datasrc',
            'frameborder',
            'height',
            'hidefocus',
            'hspace',
            'id',
            'lang',
            'language',
            'longdesc',
            'marginheight',
            'marginwidth',
            'name',
            'scrolling',
            'security',
            'src',
            'style',
            'tabindex',
            'title',
            'unselectable',
            'vspace',
            'width'],
 'ilayer': ['above',
            'background',
            'below',
            'class',
            'clip',
            'height',
            'id',
            'left',
            'name',
            'pagex',
            'pagey',
            'src',
            'style',
            'top',
            'visibility',
            'width',
            'z-index'],
 'img': ['accesskey',
         'align',
         'alt',
         'border',
         'class',
         'datafld',
         'datasrc',
         'dir',
         'dynsrc',
         'galleryimg',
         'height',
         'hidefocus',
         'hspace',
         'id',
         'ismap',
         'lang',
         'language',
         'longdesc',
         'loop',
         'lowsrc',
         'src',
         'style',
         'tabindex',
         'title',
         'unselectable',
         'usemap',
         'vspace',
         'width'],
 'input': ['accept',
           'accesskey',
           'align',
           'alt',
           'autocomplete',
           'checked',
           'class',
           'dir',
           'disabled',
           'dynsrc',
           'hidefocus',
           'hspace',
           'id',
           'lang',
           'language',
           'loop',
           'lowsrc',
           'maxlength',
           'name',
           'readonly',
           'size',
           'src',
           'style',
           'tabindex',
           'title',
           'type',
           'unselectable',
           'value',
           'vspace'],
 'ins': ['accesskey',
         'cite',
         'class',
         'contenteditable',
         'datetime',
         'dir',
         'disabled',
         'id',
         'lang',
         'language',
         'style',
         'tabindex',
         'title',
         'unselectable'],
 'isindex': ['accesskey',
             'action',
             'class',
             'dir',
             'disabled',
             'hidefocus',
             'href',
             'id',
             'lang',
             'language',
             'style',
             'tabindex',
             'title',
             'unselectable'],
 'kbd': ['accesskey',
         'class',
         'contenteditable',
         'dir',
         'disabled',
         'hidefocus',
         'id',
         'lang',
         'language',
         'style',
         'tabindex',
         'title',
         'unselectable'],
 'keygen': ['accesskey',
            'autofocus',
            'challenge',
            'class',
            'contenteditable',
            'contextmenu',
            'dir',
            'disabled',
            'draggable',
            'form',
            'hidden',
            'id',
            'keytype',
            'lang',
            'name',
            'spellcheck',
            'style',
            'tabindex',
            'title'],
 'label': ['accesskey',
           'class',
           'contenteditable',
           'datafld',
           'dataformatas',
           'datasrc',
           'dir',
           'disabled',
           'for',
           'hidefocus',
           'id',
           'lang',
           'language',
           'style',
           'tabindex',
           'title',
           'unselectable'],
 'layer': ['above',
           'background',
           'below',
           'bgcolor',
           'class',
           'clip',
           'height',
           'id',
           'left',
           'name',
           'overflow',
           'pagex',
           'pagey',
           'style',
           'title',
           'top',
           'visibility',
           'width',
           'z-index'],
 'legend': ['accesskey',
            'align',
            'class',
            'contenteditable',
            'dir',
            'disabled',
            'hidefocus',
            'id',
            'lang',
            'language',
            'style',
            'tabindex',
            'title',
            'unselectable'],
 'li': ['accesskey',
        'class',
        'contenteditable',
        'dir',
        'disabled',
        'hidefocus',
        'id',
        'lang',
        'language',
        'style',
        'tabindex',
        'title',
        'type',
        'unselectable',
        'value'],
 'link': ['charset',
          'class',
          'dir',
          'disabled',
          'href',
          'hreflang',
          'id',
          'lang',
          'media',
          'rel',
          'rev',
          'style',
          'target',
          'title',
          'type'],
 'map': ['class', 'dir', 'id', 'lang', 'style', 'title'],
 'mark': ['accesskey',
          'class',
          'contenteditable',
          'contextmenu',
          'dir',
          'draggable',
          'hidden',
          'id',
          'lang',
          'spellcheck',
          'style',
          'tabindex',
          'title'],
 'marquee': ['accesskey',
             'behavior',
             'bgcolor',
             'class',
             'contenteditable',
             'datafld',
             'dataformatas',
             'datasrc',
             'dir',
             'direction',
             'height',
             'hidefocus',
             'hspace',
             'id',
             'lang',
             'language',
             'loop',
             'scrollamount',
             'scrolldelay',
             'style',
             'tabindex',
             'title',
             'truespeed',
             'unselectable',
             'vspace',
             'width'],
 'math': ['accesskey',
          'class',
          'contenteditable',
          'contextmenu',
          'dir',
          'draggable',
          'hidden',
          'id',
          'lang',
          'spellcheck',
          'style',
          'tabindex',
          'title'],
 'menu': ['accesskey',
          'class',
          'contenteditable',
          'contextmenu',
          'dir',
          'draggable',
          'hidden',
          'id',
          'label',
          'lang',
          'spellcheck',
          'style',
          'tabindex',
          'title',
          'type'],
 'meta': ['content', 'dir', 'http-equiv', 'id', 'lang', 'name', 'scheme'],
 'meter': ['accesskey',
           'class',
           'contenteditable',
           'contextmenu',
           'dir',
           'draggable',
           'form',
           'hidden',
           'high',
           'id',
           'label',
           'lang',
           'low',
           'max',
           'min',
           'optimum',
           'spellcheck',
           'style',
           'tabindex',
           'title',
           'type',
           'value'],
 'nav': ['accesskey',
         'class',
         'contenteditable',
         'contextmenu',
         'dir',
         'draggable',
         'hidden',
         'id',
         'lang',
         'spellcheck',
         'style',
         'tabindex',
         'title'],
 'nobr': ['class',
          'contenteditable',
          'dir',
          'disabled',
          'id',
          'style',
          'title',
          'unselectable'],
 'noembed': ['class', 'id', 'style', 'title'],
 'noframes': ['class', 'dir', 'id', 'lang', 'style', 'title'],
 'noscript': ['class', 'dir', 'id', 'lang', 'style', 'title'],
 'object': ['accesskey',
            'align',
            'archive',
            'border',
            'class',
            'classid',
            'code',
            'codebase',
            'codetype',
            'data',
            'datafld',
            'datasrc',
            'declare',
            'dir',
            'height',
            'hidefocus',
            'hspace',
            'id',
            'lang',
            'name',
            'standby',
            'style',
            'tabindex',
            'title',
            'type',
            'unselectable',
            'usemap',
            'vspace',
            'width'],
 'ol': ['accesskey',
        'class',
        'compact',
        'contenteditable',
        'dir',
        'disabled',
        'hidefocus',
        'id',
        'lang',
        'language',
        'reversed',
        'start',
        'style',
        'tabindex',
        'title',
        'type',
        'unselectable'],
 'optgroup': ['class',
              'dir',
              'disabled',
              'id',
              'label',
              'lang',
              'style',
              'title'],
 'option': ['class',
            'dir',
            'disabled',
            'id',
            'label',
            'lang',
            'language',
            'selected',
            'style',
            'title',
            'value'],
 'output': ['accesskey',
            'class',
            'contenteditable',
            'contextmenu',
            'dir',
            'draggable',
            'for',
            'form',
            'hidden',
            'id',
            'lang',
            'name',
            'spellcheck',
            'style',
            'tabindex',
            'title'],
 'p': ['accesskey',
       'align',
       'class',
       'contenteditable',
       'dir',
       'disabled',
       'hidefocus',
       'id',
       'lang',
       'language',
       'style',
       'tabindex',
       'title',
       'unselectable'],
 'param': ['datafld',
           'dataformatas',
           'datasrc',
           'id',
           'name',
           'type',
           'value',
           'valuetype'],
 'pre': ['accesskey',
         'class',
         'contenteditable',
         'dir',
         'disabled',
         'hidefocus',
         'id',
         'lang',
         'language',
         'style',
         'tabindex',
         'title',
         'unselectable',
         'width',
         'wrap',
         'xml:space'],
 'progress': ['accesskey',
              'class',
              'contenteditable',
              'contextmenu',
              'dir',
              'draggable',
              'form',
              'hidden',
              'id',
              'lang',
              'max',
              'spellcheck',
              'style',
              'tabindex',
              'title',
              'value'],
 'q': ['accesskey',
       'cite',
       'class',
       'contenteditable',
       'dir',
       'disabled',
       'hidefocus',
       'id',
       'lang',
       'language',
       'style',
       'tabindex',
       'title',
       'unselectable'],
 'rp': ['accesskey',
        'class',
        'contenteditable',
        'contextmenu',
        'dir',
        'draggable',
        'hidden',
        'id',
        'lang',
        'spellcheck',
        'style',
        'tabindex',
        'title'],
 'rt': ['accesskey',
        'class',
        'contenteditable',
        'dir',
        'disabled',
        'hidefocus',
        'id',
        'lang',
        'language',
        'name',
        'style',
        'tabindex',
        'title',
        'unselectable'],
 'ruby': ['accesskey',
          'class',
          'contenteditable',
          'dir',
          'disabled',
          'hidefocus',
          'id',
          'lang',
          'language',
          'name',
          'style',
          'tabindex',
          'title',
          'unselectable'],
 's': ['accesskey',
       'class',
       'contenteditable',
       'dir',
       'disabled',
       'hidefocus',
       'id',
       'lang',
       'language',
       'style',
       'tabindex',
       'title',
       'unselectable'],
 'samp': ['accesskey',
          'class',
          'contenteditable',
          'dir',
          'disabled',
          'hidefocus',
          'id',
          'lang',
          'language',
          'style',
          'tabindex',
          'title',
          'unselectable'],
 'script': ['charset',
            'defer',
            'event',
            'for',
            'id',
            'language',
            'src',
            'type',
            'xml:space'],
 'section': ['accesskey',
             'class',
             'contenteditable',
             'contextmenu',
             'dir',
             'draggable',
             'hidden',
             'id',
             'lang',
             'spellcheck',
             'style',
             'tabindex',
             'title'],
 'select': ['accesskey',
            'align',
            'class',
            'datafld',
            'datasrc',
            'dir',
            'disabled',
            'hidefocus',
            'id',
            'lang',
            'language',
            'multiple',
            'name',
            'size',
            'style',
            'tabindex',
            'title',
            'unselectable'],
 'small': ['accesskey',
           'class',
           'contenteditable',
           'dir',
           'hidefocus',
           'id',
           'lang',
           'language',
           'style',
           'tabindex',
           'title',
           'unselectable'],
 'source': ['accesskey',
            'class',
            'contenteditable',
            'contextmenu',
            'dir',
            'draggable',
            'hidden',
            'id',
            'lang',
            'media',
            'spellcheck',
            'src',
            'style',
            'tabindex',
            'title',
            'type'],
 'span': ['accesskey',
          'class',
          'contenteditable',
          'datafld',
          'dataformatas',
          'datasrc',
          'dir',
          'hidefocus',
          'id',
          'lang',
          'language',
          'style',
          'tabindex',
          'title',
          'unselectable'],
 'strike': ['accesskey',
            'class',
            'contenteditable',
            'dir',
            'disabled',
            'hidefocus',
            'id',
            'lang',
            'language',
            'style',
            'tabindex',
            'title',
            'unselectable'],
 'strong': ['accesskey',
            'class',
            'contenteditable',
            'dir',
            'disabled',
            'hidefocus',
            'id',
            'lang',
            'language',
            'style',
            'tabindex',
            'title',
            'unselectable'],
 'style': ['dir',
           'disabled',
           'id',
           'lang',
           'media',
           'title',
           'type',
           'xml:space'],
 'sub': ['accesskey',
         'class',
         'contenteditable',
         'dir',
         'disabled',
         'hidefocus',
         'id',
         'lang',
         'language',
         'style',
         'tabindex',
         'title',
         'unselectable'],
 'summary': ['accesskey',
             'class',
             'contenteditable',
             'contextmenu',
             'dir',
             'draggable',
             'hidden',
             'id',
             'lang',
             'spellcheck',
             'style',
             'tabindex',
             'title'],
 'sup': ['accesskey',
         'class',
         'contenteditable',
         'dir',
         'hidefocus',
         'id',
         'lang',
         'language',
         'style',
         'tabindex',
         'title',
         'unselectable'],
 'svg': ['accesskey',
         'class',
         'contenteditable',
         'contextmenu',
         'dir',
         'draggable',
         'hidden',
         'id',
         'lang',
         'spellcheck',
         'style',
         'tabindex',
         'title'],
 'table': ['accesskey',
           'background',
           'bgcolor',
           'border',
           'bordercolor',
           'bordercolordark',
           'bordercolorlight',
           'cellpadding',
           'cellspacing',
           'class',
           'cols',
           'datapagesize',
           'datasrc',
           'dir',
           'frame',
           'height',
           'hidefocus',
           'hspace',
           'id',
           'lang',
           'language',
           'rules',
           'style',
           'summary',
           'tabindex',
           'title',
           'unselectable',
           'vspace',
           'width'],
 'tbody': ['accesskey',
           'align',
           'bgcolor',
           'char',
           'charoff',
           'class',
           'dir',
           'hidefocus',
           'id',
           'lang',
           'language',
           'style',
           'tabindex',
           'title',
           'unselectable',
           'valign'],
 'td': ['abbr',
        'accesskey',
        'align',
        'axis',
        'background',
        'bgcolor',
        'bordercolor',
        'bordercolordark',
        'bordercolorlight',
        'char',
        'charoff',
        'class',
        'colspan',
        'dir',
        'headers',
        'height',
        'hidefocus',
        'id',
        'lang',
        'language',
        'nowrap',
        'rowspan',
        'scope',
        'style',
        'tabindex',
        'title',
        'unselectable',
        'valign',
        'width'],
 'textarea': ['accesskey',
              'class',
              'cols',
              'datafld',
              'datasrc',
              'dir',
              'disabled',
              'hidefocus',
              'id',
              'lang',
              'language',
              'name',
              'readonly',
              'rows',
              'style',
              'tabindex',
              'title',
              'wrap'],
 'tfoot': ['accesskey',
           'align',
           'char',
           'charoff',
           'class',
           'dir',
           'hidefocus',
           'id',
           'lang',
           'language',
           'style',
           'tabindex',
           'title',
           'unselectable',
           'valign'],
 'th': ['abbr',
        'accesskey',
        'align',
        'axis',
        'background',
        'bgcolor',
        'bordercolor',
        'bordercolordark',
        'bordercolorlight',
        'char',
        'charoff',
        'class',
        'colspan',
        'dir',
        'headers',
        'height',
        'hidefocus',
        'id',
        'lang',
        'language',
        'nowrap',
        'rowspan',
        'scope',
        'style',
        'tabindex',
        'title',
        'unselectable',
        'valign'],
 'thead': ['accesskey',
           'align',
           'char',
           'charoff',
           'class',
           'dir',
           'hidefocus',
           'id',
           'lang',
           'language',
           'style',
           'tabindex',
           'title',
           'unselectable',
           'valign'],
 'time': ['accesskey',
          'class',
          'contenteditable',
          'contextmenu',
          'datetime',
          'dir',
          'draggable',
          'hidden',
          'id',
          'lang',
          'pubdate',
          'spellcheck',
          'style',
          'tabindex',
          'title'],
 'title': ['dir', 'id', 'lang'],
 'tr': ['accesskey',
        'align',
        'bgcolor',
        'bordercolor',
        'bordercolordark',
        'bordercolorlight',
        'char',
        'charoff',
        'class',
        'dir',
        'height',
        'hidefocus',
        'id',
        'lang',
        'language',
        'style',
        'tabindex',
        'title',
        'valign'],
 'tt': ['accesskey',
        'class',
        'contenteditable',
        'dir',
        'disabled',
        'hidefocus',
        'id',
        'lang',
        'language',
        'style',
        'tabindex',
        'title',
        'unselectable'],
 'u': ['accesskey',
       'class',
       'contenteditable',
       'dir',
       'hidefocus',
       'id',
       'lang',
       'language',
       'style',
       'tabindex',
       'title',
       'unselectable'],
 'ul': ['accesskey',
        'class',
        'compact',
        'contenteditable',
        'dir',
        'hidefocus',
        'id',
        'lang',
        'language',
        'style',
        'tabindex',
        'title',
        'type',
        'unselectable'],
 'var': ['accesskey',
         'class',
         'contenteditable',
         'dir',
         'hidefocus',
         'id',
         'lang',
         'language',
         'style',
         'tabindex',
         'title',
         'unselectable'],
 'video': ['accesskey',
           'autoplay',
           'class',
           'contenteditable',
           'contextmenu',
           'dir',
           'draggable',
           'height',
           'hidden',
           'id',
           'lang',
           'loop',
           'poster',
           'preload',
           'spellcheck',
           'src',
           'style',
           'tabindex',
           'title',
           'width'],
 'wbr': ['id'],
 'xml': ['id', 'src'],
 'xmp': ['accesskey',
         'class',
         'contenteditable',
         'dir',
         'hidefocus',
         'id',
         'lang',
         'language',
         'style',
         'tabindex',
         'title',
         'unselectable']}

HTML_ATTRIBUTES_VALUES = {'abbr': [],
 'above': [],
 'accept': ['*',
            'application/msexcel',
            'application/msword',
            'application/pdf',
            'application/rtf',
            'application/x-zip-compressed',
            'text/html',
            'text/plain'],
 'accept-charset': ['*', 'ISO-8859-1', 'unknown'],
 'accesskey': [],
 'action': [],
 'align': ['absbottom',
           'absmiddle',
           'baseline',
           'bottom',
           'center',
           'justify',
           'left',
           'middle',
           'right',
           'texttop',
           'top'],
 'alink': [],
 'allowtransparency': ['no', 'yes'],
 'alt': [],
 'application': ['no', 'yes'],
 'archive': [],
 'autocomplete': ['off', 'on'],
 'autofocus': [],
 'autoplay': ['false', 'true'],
 'axis': [],
 'background': [],
 'balance': [],
 'behavior': ['alternate', 'scroll', 'slide'],
 'below': [],
 'bgcolor': [],
 'bgproperties': ['fixed'],
 'border': [],
 'bordercolor': [],
 'bordercolordark': [],
 'bordercolorlight': [],
 'bottommargin': [],
 'cellpadding': [],
 'cellspacing': [],
 'challenge': [],
 'char': [],
 'charoff': [],
 'charset': ['*',
             'HZ-GB-2312',
             'ISO-2022-JP',
             'ISO-2022-JP-2',
             'ISO-2022-KR',
             'ISO-8859-1',
             'ISO-8859-10',
             'ISO-8859-15',
             'ISO-8859-2',
             'ISO-8859-3',
             'ISO-8859-4',
             'ISO-8859-5',
             'ISO-8859-6',
             'ISO-8859-7',
             'ISO-8859-8',
             'ISO-8859-9',
             'Shift_JIS',
             'UTF-8',
             'cp1250',
             'cp1251',
             'cp1252',
             'cp1253',
             'cp1254',
             'cp1255',
             'cp1256',
             'cp1257',
             'cp1258'],
 'checked': ['checked'],
 'cite': [],
 'class': [],
 'clear': ['all', 'left', 'none', 'right'],
 'clip': [],
 'code': [],
 'codebase': [],
 'color': [],
 'cols': [],
 'colspan': [],
 'compact': ['compact'],
 'content': ['*',
             'text/html',
             'text/html; charset=HZ-GB-2312',
             'text/html; charset=ISO-2022-JP',
             'text/html; charset=ISO-2022-JP-2',
             'text/html; charset=ISO-2022-KR',
             'text/html; charset=ISO-8859-10',
             'text/html; charset=ISO-8859-15',
             'text/html; charset=ISO-8859-2',
             'text/html; charset=ISO-8859-3',
             'text/html; charset=ISO-8859-4',
             'text/html; charset=ISO-8859-5',
             'text/html; charset=ISO-8859-6',
             'text/html; charset=ISO-8859-7',
             'text/html; charset=ISO-8859-8',
             'text/html; charset=ISO-8859-9',
             'text/html; charset=Shift_JIS',
             'text/html; charset=UTF-8',
             'text/html; charset=cp1250',
             'text/html; charset=cp1251',
             'text/html; charset=cp1252',
             'text/html; charset=cp1253',
             'text/html; charset=cp1254',
             'text/html; charset=cp1255',
             'text/html; charset=cp1256',
             'text/html; charset=cp1257',
             'text/html; charset=cp1258',
             'text/html; charset=iso-8859-1'],
 'contenteditable': ['false', 'inherit', 'true'],
 'contextmenu': [],
 'controls': ['false', 'true'],
 'coords': [],
 'data': [],
 'datafld': [],
 'dataformatas': ['html', 'text'],
 'datapagesize': [],
 'datasrc': [],
 'datetime': [],
 'declare': ['declare'],
 'defer': ['defer'],
 'dir': ['ltr', 'rtl'],
 'direction': ['down', 'left', 'right', 'up'],
 'disabled': ['false', 'true'],
 'draggable': ['auto', 'false', 'true'],
 'dynsrc': [],
 'enctype': ['*',
             'application/x-www-form-urlencoded',
             'multipart/form-data',
             'text/plain'],
 'event': [],
 'face': [],
 'for': [],
 'form': [],
 'frame': ['above',
           'below',
           'border',
           'box',
           'hsides',
           'lhs',
           'rhs',
           'void',
           'vsides'],
 'frameborder': ['0', '1', 'no', 'yes'],
 'framespacing': [],
 'galleryimg': ['false', 'no', 'true', 'yes'],
 'headers': [],
 'height': [],
 'hidden': ['false', 'true'],
 'hidefocus': ['false', 'true'],
 'high': [],
 'href': [],
 'hreflang': [],
 'hspace': [],
 'http-equiv': ["Content-Type"],
 'icon': [],
 'id': [],
 'keytype': [],
 'label': [],
 'lang': [],
 'language': ['*',
              'JScript',
              'JavaScript',
              'JavaScript1.1',
              'JavaScript1.2',
              'VBScript',
              'javascript',
              'jscript',
              'php',
              'vbs',
              'vbscript'],
 'left': [],
 'leftmargin': [],
 'link': [],
 'longdesc': [],
 'loop': [],
 'low': [],
 'lowsrc': [],
 'marginheight': [],
 'marginwidth': [],
 'max': [],
 'maxlength': [],
 'mayscript': [],
 'media': ['*',
           'all',
           'aural',
           'braille',
           'other',
           'print',
           'projection',
           'screen'],
 'method': ['get', 'post'],
 'methods': [],
 'min': [],
 'multiple': ['multiple'],
 'name': [],
 'nohref': ['nohref'],
 'noresize': ['noresize'],
 'noshade': ['noshade'],
 'nowrap': ['nowrap'],
 'object': [],
 'open': ['false', 'true'],
 'optimum': [],
 'overflow': ['clip', 'none'],
 'pagex': [],
 'pagey': [],
 'palette': ['background', 'foreground'],
 'pluginspage': [],
 'point-size': [],
 'poster': [],
 'preload': ['auto', 'metadata', 'none'],
 'profile': [],
 'pubdate': ['false', 'true'],
 'radiogroup': [],
 'readonly': ['readonly'],
 'rel': ['alternate',
         'bookmark',
         'chapter',
         'contents',
         'copyright',
         'glossary',
         'help',
         'index',
         'next',
         'prev',
         'section',
         'start',
         'stylesheet',
         'subsection'],
 'rev': ['alternate',
         'bookmark',
         'chapter',
         'contents',
         'copyright',
         'glossary',
         'help',
         'index',
         'next',
         'prev',
         'section',
         'start',
         'stylesheet',
         'subsection'],
 'reversed': [],
 'rightmargin': [],
 'rows': [],
 'rowspan': [],
 'rules': ['all', 'cols', 'groups', 'none', 'rows'],
 'scheme': [],
 'scope': ['col', 'colgroup', 'row', 'rowgroup'],
 'scroll': ['auto', 'no', 'yes'],
 'scrollamount': [],
 'scrolldelay': [],
 'scrolling': ['auto', 'no', 'yes'],
 'selected': ['selected'],
 'shape': ['circle', 'default', 'poly', 'rect'],
 'size': ['*', '1', '2', '3', '4', '5', '6', '7'],
 'span': [],
 'spellcheck': ['default', 'false', 'true'],
 'src': [],
 'standby': [],
 'start': [],
 'style': [],
 'summary': [],
 'tabindex': [],
 'target': ['*', '_blank', '_parent', '_self', '_top'],
 'text': [],
 'title': [],
 'top': [],
 'truespeed': ['truespeed'],
 'type': ['*',
          '1',
          'A',
          'I',
          'a',
          'application/javascript',
          'application/x-shockwave-flash',
          'button',
          'checkbox',
          'circle',
          'color',
          'date',
          'datetime',
          'datetime-local',
          'disc',
          'email',
          'file',
          'hidden',
          'i',
          'image',
          'month',
          'number',
          'password',
          'radio',
          'range',
          'reset',
          'search',
          'square',
          'submit',
          'tel',
          'text',
          'text/css',
          'text/javascript',
          'text/jscript',
          'text/php',
          'text/tcl',
          'text/vbscript',
          'time',
          'url',
          'week'],
 'units': ['em', 'px'],
 'unselectable': ['off', 'on'],
 'urn': [],
 'usemap': [],
 'valign': ['baseline', 'bottom', 'center', 'middle', 'top'],
 'value': [],
 'valuetype': ['data', 'object', 'ref'],
 'visibility': ['hidden', 'inherit', 'shown'],
 'vlink': [],
 'volume': [],
 'vspace': [],
 'weight': ['100', '200', '300', '400', '500', '600', '700', '800', '900'],
 'width': [],
 'wrap': ['hard', 'off', 'soft'],
 'xml:space': ['preserve'],
 'xmlns': ['http://www.w3.org/1999/xhtml'],
 'z-index': []}

